<?php
/**
 * Plugin Name: Author Info Block v1
 * Description: An example ACF PRO Block to display Author Info.
 * Text Domain: demo-author-block-acf
 * Author: WP Engine
 * Version: 1.0.0
 * Update URI: false
 */

/**
 * Register our blocks.
 *
 * @link https://www.advancedcustomfields.com/resources/whats-new-with-acf-blocks-in-acf-6/
 *
 * @return void
 */
function demo_author_block_acf_v1_blocks_register() {
	/**
	 * We register our block's with WordPress's handy
	 * register_block_type();
	 *
	 * @link https://developer.wordpress.org/reference/functions/register_block_type/
	 */
	// Author Info (parent) block.
	register_block_type( __DIR__ . '/blocks/author-info' );
	// Author Twitter (child) block.
	register_block_type( __DIR__ . '/blocks/author-twitter' );
}
add_action( 'init', 'demo_author_block_acf_v1_blocks_register', 5 );

/**
 * Register our Author Twitter field group
 * directly in our PHP for portability.
 *
 * @link https://www.advancedcustomfields.com/resources/register-fields-via-php/
 */
add_action(
	'acf/include_fields',
	function () {
		if ( ! function_exists( 'acf_add_local_field_group' ) ) {
			return;
		}

		acf_add_local_field_group(
			array(
				'key'      => 'group_64e3e09959e8f',
				'title'    => 'Author Twitter',
				'fields'   => array(
					array(
						'key'          => 'field_64e3e09a7a544',
						'label'        => 'Twitter',
						'name'         => 'twitter',
						'type'         => 'text',
						'instructions' => 'https://twitter.com/[username]',
						'prepend'      => 'https://twitter.com/',
					),
				),
				'location' => array(
					array(
						array(
							'param'    => 'block',
							'operator' => '==',
							'value'    => 'acf/author-twitter-v1',
						),
					),
				),
			)
		);
	}
);
